 using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
 using PsgBase;

namespace Template2
{
    [EditorClass, ViewGrid]
    public partial class Template1 : Base
    {
        #region GlobalVariables

        Template1BE.Template1DataTable table = new Template1BE.Template1DataTable();
        Template1BE.Template1Row rowA = null;

        #endregion

        #region Constructors

        public Template1()
        {
            InitializeComponent();
        }

        public Template1(ViewGrid _view)
            : base(_view)
        {
            InitializeComponent();
        }

        public Template1(LookupGrid _lookup)
            : base(_lookup)
        {
            InitializeComponent();
        }

        #endregion

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);
            context.PsgFieldKey = "id";
            context.PsgFieldDisplay = "column1";
            context.PsgCommand = "template1";
            context.PsgServerTableName = "template1";

        }

        public override void PsgStart()
        {
            base.PsgStart();
            AddTable("template1", ID);
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "TEMPLATE1":
                    table = (Template1BE.Template1DataTable)SetMainData(dt, table);
                    rowA = (Template1BE.Template1Row)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edcol1, table.column1Column);
            BindData(dtcol2, table.column2Column);
            BindChecked(chkcol3, table.column3Column);
            base.PsgBind();

        }

        public override void PsgView()
        {
            base.PsgView();
            this.ColumnsView(table.column1Column, "Column1");
            this.ColumnsView(table.column2Column, "Column2");

            this.FiltersView(table.column1Column, "Column1");
            this.FiltersView(table.column2Column, "Column2");

        }

        public override void PsgLookup()
        {
            base.PsgLookup();
            this.ColumnsLookup(table.column1Column, "Column1");
            this.ColumnsLookup(table.column2Column, "Column2");

            this.FiltersLookup(table.column1Column, "Column1");
            this.FiltersLookup(table.column2Column, "Column2");

        }
    }
}